using System.Diagnostics;
using System.Reflection.PortableExecutable;

namespace BallDemo
{
    public class Demo
    {
        public static int Height = 40;
        public static int Width = 150;
        public static int RefreshRate = 20;
        private IList<IObject> objects;
        private Game game;
        public Demo()
        {
            Console.SetWindowSize(Width, Height);
            this.objects = new List<IObject>();
            this.game = new Game();
        }
        public void Run(int tick)
        {
            this.objects = game.GetObjects(tick);
            DisplayPrinter.Print(objects);
            foreach (var obj in objects)
            {
                obj.Run();
            }
        }
        
        
    }

    public class DisplayPrinter
    {
        public static void Print(IEnumerable<IObject> objects)
        {
            Clear();
            for (int y = 0; y < Demo.Height+1; y++)
            {
                char[] chars = new char[Demo.Width+1];
                for (int x = 0; x < Demo.Width+1; x++)
                {
                    chars[x] = GetBoarders(x, y)
                    ?? objects
                        .Select(o => o.GetChar(new(x, y)))
                        .Where(x => x != null)
                        .FirstOrDefault()
                        ?? ' ';
                }
                Console.WriteLine(chars);
            }
        }
        private static char? GetBoarders(int x, int y)
        {
            if (y == 0 || y == Demo.Height) { return '#'; }
            if (x == 0 || x == Demo.Width) { return '#'; }
            return null;
        }
        private static void Clear()
        {
            Console.Clear();
            //for (int i = 0; i < Demo.Height; i++)
            //{
            //	Console.WriteLine();
            //}
        }
    }
    public class Ball : IObject
    {
        public (decimal x, decimal y) pos;
        public (decimal x, decimal y) vector;
        public int size { get; set; }
        private int time;
        public int Time { get => this.time;  set { time = value * Demo.RefreshRate; }}
        public void Run()
        {
            this.pos = new(this.pos.x + this.vector.x, this.pos.y + this.vector.y);
            this.UpdateVector();
            this.time--;
        }

        private void UpdateVector()
        {
            this.vector.y += 0.5m;
            if (this.pos.y < this.size || this.pos.y >= Demo.Height - this.size)
            {
                //bounce Up/Down
                this.vector.y *= -1;
                this.vector.y *= 0.8m;
                this.PlaySound();
            }
            if (this.pos.x < this.size || this.pos.x >= Demo.Width - this.size)
            {
                //bounce Left/right
                this.vector.x *= -1;
                this.PlaySound();
            }
        }

        void PlaySound()
        {
            var process = new Process
            {
                StartInfo = new ProcessStartInfo
                {
                    FileName = "afplay",
                    Arguments = "bounce.wav",
                    UseShellExecute = false
                }
            };
            process.Start();
        }

        public char? GetChar((int x, int y) pixel)
        {

            int xDiff = (int)(pixel.x - this.pos.x);
            int yDiff = (int)(pixel.y - this.pos.y);
            if (Math.Sqrt((xDiff * xDiff) + (yDiff * yDiff)) <= this.size)
            {
                return 'X';
            }
            return null;
        }
    }

    public interface IObject
    {
        int Time { get; }
        void Run();
        char? GetChar((int x, int y) pixel);
    }
}